/*------------------------------------------------------------------------------*
 * File Name PE.c: Contains Origin C source code for Labtalk PE commands		*
 * Creation: AW																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) OriginLab Corp. 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// you can include just this typical header file for most Origin built-in functions and classes
// and it takes a reasonable amount of time to compile, 
#include <Folder.h>
#include <page.h>
#include <Project.h>

////////////////////////////////////////////////////////////////////////////////////
// A sample program to illustrate how to use Project Explore from Origin C by
// creating labtalk commands that are similar to DOS commands
// the following commands are supported once this file is compiled
// PEDir:	List pages and folders
// PEMD:	Creat a new folder
// PERD:	Remove an existing folder
// PECD:	Change the current path(folder)
// PEMV:	Move a page or subfolder in current folder to another folder
// PESCH:	find a page in current folder and subfolder, and printf full path of location if find.
// PEREN:	Rename the Page or subfoler 
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// static functions in OriginC are not visible from Labtalk
static int PageTypeStr2Int(string strType)
{
	if( strType.IsEmpty() )
		return 0; // any page
	
	strType.MakeUpper();
	switch( strType[0] )
	{
	case 'W':
		return EXIST_WKS;
	case 'P': case 'G':
		return EXIST_GRAPH;
	case 'M':
		return EXIST_MATRIX;
	case 'N':
		return EXIST_NOTES;
	case 'L':
		return EXIST_LAYOUT;
	}
	return 0;
}

///////////////////////////////////////////////////////////////////////	
// PEDir name    		List  all pages matching name
// PEDir name type		List all matched pages of given type, "W', "P", "M", "N", "L". etc
void PEDir(string pagename = "", string strPageType = "")
{
	string strName;
	Folder fld = Project.ActiveFolder();
		
	if( strPageType.IsEmpty() && pagename.IsEmpty() )// no win_type/page_name specified, will show subfolders
	{
		foreach(Folder sub in fld.Subfolders)
		{
			strName = sub.GetName();
			printf("<Folder> %s\n", strName);
		}
	}
	
	int nWinType = PageTypeStr2Int(strPageType);
	PageBase page;		
	foreach(page in fld.Pages)
	{
		if( 0 == nWinType || nWinType == page.GetType() )
		{
			strName = page.GetName();
			if( strName.Match(pagename) )
				printf("%s\n", strName);
		}
	}
} 	
///////////////////////////////////////////////////////////////////////
// PEMD:	Creat a new subfolder
// If the name already exists, it will add number after name.
void PEMD(string subfolderName)
{
	Folder fld = Project.ActiveFolder();
	Folder subfld = fld.AddSubfolder(subfolderName);
	if( !subfld.IsValid() )
	{
		printf("Error!!! Can't Create new subfolder %s !\n", subfolderName);
	}
}

///////////////////////////////////////////////////////////////////////
// PERD:	Remove an exist folder
// If bFolderPrompt or bPagePrompt is TRUE then Origin will prompt the user to verify.
void PERD(string subfolderName, BOOL bFolderPrompt = FALSE , BOOL bPagePrompt = FALSE)
{
	Folder fld = Project.ActiveFolder();
	if( !fld.RemoveSubFolder(subfolderName) )
	{
		printf("Error!!! Can't remove subfolder %s !\n", subfolderName);
	}
}

//////////////////////////////////////////////////////////////////////
// PECD:	Change the current path
// You can use both absolue and relative way to change current path, like "/a/b", "../b"
// When use absolut way, the project name can be omitted, like "/" can return to root folder.
void PECD(string strPathName) 
{
	if( !Project.ActivateFolder(strPathName) )	
	{
		printf("Error!!! Can't change path to %s !", strPathName);
	}
}

/////////////////////////////////////////////////////////////////////////
// PEMV:	Move a page or subfolder in current folder to another folder
void PEMV(string strItemName, string strPathName)
{
	Folder fld = Project.ActiveFolder();
	if( !fld.Move(strItemName, strPathName) )
	{
		printf( " Error!!! Can't move %s to %s !", strItemName, strPathName );
	}
}

//////////////////////////////////////////////////////////////////////////
// PESCH: Search through the Project's folders for a specified page.
void PESCH(string strPageName)
{
	Folder fldLoaction = Project.GetFolderWithPage(strPageName);
	if( fldLoaction.IsValid() )
	{
		string path = fldLoaction.GetPath();
		printf("%s",path);
	}
	else
	{
		printf("Error!!! Can't find page %s !", strPageName); 
	}
}

////////////////////////////////////////////////////////////////////////
// PEREN:	Rename the Page or subfoler 
void PEREN(string strOldName, string strNewName)
{
	string 	strName;
	Folder fld = Project.ActiveFolder();
	
	foreach(PageBase page in fld.Pages)
	{
		strName = page.GetName();
		if ( strName.Match(strOldName) )
		{
			if ( !page.Rename( strNewName ) )
			{
				printf( " Error!!! Can't Rename Page %s to %s !", strOldName, strNewName );
				return;
			}
			else
				return;
		}
	}
	foreach(Folder sub in fld.Subfolders)
	{
		strName = sub.GetName();
		if( strName.Match(strOldName) )
		{
			if( !sub.Rename(strNewName) )
			{
				printf("Error!!! Can't Rename subfolder %s to %s !", strOldName, strNewName);
				return;
			}
			else
				return;
		}
	}
	printf("Error!!! Can't find %s in current folder !", strOldName);
}